/*
Sample code to interface DS1788X or DS1288X RTC to PIC18 microcontrollers
To be compiled with HI-TECH PIC18 Compilers
Freely distributable in this original form.
(c) 2009 Pasan Hettiarachchi
(c) Microsolutions
Any questions or comments?  admin@microsolutions.info
*/
 
#include <pic18.h>
#include"delay.h"
#include"serial.h"
#include "rtc.h"
#include <stdio.h>


__CONFIG (1,ECDB4 & OSCSDIS);
__CONFIG (2,WDTDIS);
__CONFIG (4,LVPDIS & STVRDIS);
__CONFIG (5,CPB);

void main(){
	
	dateTimeRTC dateTime ;
	
	ADCON1=0x06;		// for newer PIC18F4580 etc.. not important
	CMCON=0x07;			// 
	
	TRISC=0b10111111;	//
	TRISB=0b11100001;  //LATB1-LATB4 are used as control pins for the RTC parallel interface
	
	init_comms();
	
	
/*	
	Put correct values to dateTime structure and
	uncomment these lines to set the date time and intialize RTC
	
	dateTime.year=4;
	dateTime.month=10;
	dateTime.dateOfTheMonth=31;
	dateTime.hours=13;
	dateTime.dayOfTheWeek=1;
	dateTime.minutes=27;
	dateTime.seconds=0;
	
	intialiseRTC(&dateTime,0);
	
*/	
	
	while(1){
		
		DelayMs(250);
		
		if (readDateTime(&dateTime)) {
		
			printf("%02d-%02d-%02d  %02d:%02d:%02d\n",dateTime.year,dateTime.month,dateTime.dateOfTheMonth,
					dateTime.hours,dateTime.minutes,dateTime.seconds);
							
		}
		
	}
		
}

	
	
	
