#include <pic18.h>

#include "always.h"
#include "rtc.h"

void RTCwriteData(unsigned char adr, unsigned char data){
	RTC_CS=LOW;
	RTC_RD=HIGH;
	RTC_WE=HIGH;
	RTC_AS=HIGH;
	RTC_DATA_DIR=OUTPUT_PORT;
	RTC_AD_DATA=adr;
	asm("nop");
	RTC_AS=LOW;
	RTC_WE=LOW;
	RTC_WR_DATA=data;
	asm("nop");
	RTC_WE=HIGH;
	asm("nop");
	RTC_CS=HIGH;
	//RTC_RD=LOW;
	RTC_DATA_DIR=INPUT_PORT;
}	
	
unsigned char RTCreadData(unsigned char adr){

	unsigned char data;
	RTC_CS=LOW;
	RTC_RD=HIGH;
	RTC_WE=HIGH;
	RTC_AS=HIGH;
	RTC_DATA_DIR=OUTPUT_PORT;
	RTC_AD_DATA=adr;
	asm("nop");
	RTC_AS=LOW;
	RTC_DATA_DIR=INPUT_PORT;
	RTC_RD=LOW;
	asm("nop");
	data=RTC_RD_DATA;
	RTC_RD=HIGH;
	RTC_CS=HIGH;
	//RTC_RD=LOW;
	return data;
}
	
	
void RTCintialise(volatile dateTimeRTC* dateTime,unsigned char divider){
	
	
	RTCwriteData(REGB , 0b10000110); //SET=1, DM=1, 24H=1,DSE=0, interrupts disabled
	
	RTCwriteData(SECONDS,dateTime->seconds);
	RTCwriteData(MINUTES,dateTime->minutes);
	RTCwriteData(HOURS,dateTime->hours);
	RTCwriteData(DAYOFTHEWEEK,dateTime->dayOfTheWeek);
	RTCwriteData(DATEOFTHEMONTH,dateTime->dateOfTheMonth);
	RTCwriteData(MONTH,dateTime->month);
	RTCwriteData(YEAR,dateTime->year);
	 
	RTCwriteData(REGA ,0x20);
	RTCwriteData(REGB,0b00000110); //SET=0;
}

void RTCcontrolOSC(unsigned char mode){
	unsigned char temp;
	temp=RTCreadData(REGA);
	RTCwriteData(REGA,(0x0F&temp));
}


unsigned char RTCreadDateTime(volatile dateTimeRTC* dateTime){

	unsigned char tempA;
	tempA=RTCreadData(REGA);

	if((tempA & 0b10000000)==0){
		
		dateTime->seconds=RTCreadData(SECONDS);
		dateTime->minutes=RTCreadData(MINUTES);
		dateTime->hours=RTCreadData(HOURS);
		dateTime->dayOfTheWeek=RTCreadData(DAYOFTHEWEEK);
		dateTime->dateOfTheMonth=RTCreadData(DATEOFTHEMONTH);
		dateTime->month=RTCreadData(MONTH);
		dateTime->year=RTCreadData(YEAR);
		
		return TRUE;
	}
	else return FALSE;
}
	
