
#ifndef __RTC_H
#define __RTC_H

//defining pins
#define RTC_WR_DATA LATD
#define RTC_AD_DATA LATD
#define RTC_RD_DATA PORTD
#define RTC_DATA_DIR TRISD
#define RTC_WE LATB3
#define RTC_RD LATB4
#define RTC_CS LATB1
#define RTC_AS LATB2


//defining data direction

#define INPUT_PORT 0xFF
#define OUTPUT_PORT 0x00

//registers of the RTC
#define SECONDS			0x00
#define SECONDSALARM	0x01
#define MINUTES			0x02
#define MINUTESALARM	0x03
#define HOURS			0x04
#define HOURSALARM		0x05
#define DAYOFTHEWEEK	0x06
#define DATEOFTHEMONTH	0x07
#define MONTH			0x08
#define YEAR			0x09
#define REGA 			0x0A
#define REGB 			0x0B
#define REGC 			0x0C
#define REGD 			0x0D


//structure to hold date and time
typedef struct {
	
		unsigned char seconds;
		unsigned char minutes;
		unsigned char hours;
		unsigned char dayOfTheWeek;
		unsigned char dateOfTheMonth;
		unsigned char month;
		unsigned char year;
		} dateTimeRTC;


//function prototypes

void RTCwriteData(unsigned char adr, unsigned char data);
unsigned char RTCreadData(unsigned char adr);
void RTCintialise(volatile dateTimeRTC* dateTime,unsigned char divider);
void RTCcontrolOSC(unsigned char mode);

unsigned char RTCreadDateTime(volatile dateTimeRTC* dateTime);

#endif
