#ifndef __SHT75_H
#define __SHT75_H

typedef union 
{ unsigned int i;
  float f;
} value;

//----------------------------------------------------------------------------------
// modul-var
//----------------------------------------------------------------------------------
enum {TEMP,HUMI};

#define	LOW_DATA  LATD1=0
#define CAPTURE_DATA TRISD1=0
			
#define RELEASE_DATA TRISD1=1
#define DATA RD1
#define	SCK   	LATD0

#define noACK 0
#define ACK   1
                            //adr  command  r/w
#define STATUS_REG_W 0x06   //000   0011    0
#define STATUS_REG_R 0x07   //000   0011    1
#define MEASURE_TEMP 0x03   //000   0001    1
#define MEASURE_HUMI 0x05   //000   0010    1
#define SHT_RESET    0x1e   //000   1111    0


unsigned char s_write_byte(unsigned char value);
unsigned char s_read_byte(unsigned char ack);
void s_transstart(void);
void s_connectionreset(void);
unsigned char s_softreset(void);
unsigned char s_read_statusreg(unsigned char *p_value, unsigned char *p_checksum);
unsigned char s_write_statusreg(unsigned char *p_value);
unsigned char s_measure(unsigned char *p_value, unsigned char *p_checksum, unsigned char mode);
void calc_sth11(float *p_humidity ,float *p_temperature);
float calc_dewpoint(float h,float t);

#endif
