/*
Simple code to interface SHT75 sensor to PIC18 microcontrollers
To be compiled with HI-TECH PIC18 Compilers
Freely distributable in this original form.
(c) 2009 Pasan Hettiarachchi
(c) Microsolutions
Any questions or comments?  admin@microsolutions.info
*/
 

#include <pic18.h>
#include "always.h"
#include"delay.h"
#include"serial.h"
#include "SHT75.h"
#include<stdio.h>


__CONFIG (1,XT );
__CONFIG (2,WDTDIS);
__CONFIG (4,LVPDIS & STVRDIS);

void main(){
//----------------------------------------------------------------------------------
// sample program that shows how to use SHT11 functions
// 1. connection reset 
// 2. measure humidity [ticks](12 bit) and temperature [ticks](14 bit)
// 3. calculate humidity [%RH] and temperature [C]
// 4. calculate dew point [C]
// 5. print temperature, humidity, dew point  
	float dew_point;
  	unsigned char error,checksum;
 	//unsigned int i;
	value humi_val,temp_val;


	ADCON1=0x06;
	CMCON=0x07;
	
	TRISD=0b11111110; //RD0 is CLK and RD1 is DATA of the SENSIBUS
	//Pin definitions are also given in SHT75.h
	
	init_comms();
	s_connectionreset();

  while(1)
  { error=0;
    error+=s_measure((unsigned char*) &humi_val.i,&checksum,HUMI);  //measure humidity
    error+=s_measure((unsigned char*) &temp_val.i,&checksum,TEMP);  //measure temperature
    if(error!=0) s_connectionreset();                 //in case of an error: connection reset
    else
    { humi_val.f=(float)humi_val.i;                   //converts integer to float
      temp_val.f=(float)temp_val.i;                   //converts integer to float
      calc_sth11(&humi_val.f,&temp_val.f);            //calculate humidity, temperature
      dew_point=calc_dewpoint(humi_val.f,temp_val.f);
		//putch('A');
		//putch('\n'); //calculate dew point
      printf("temp:%5.2fC humi:%5.2f dew point:%5.2f\n",temp_val.f,humi_val.f,dew_point);
      
    }
    //----------wait approx. 0.8s to avoid heating up SHTxx------------------------------      
    DelayS(2);     //(be sure that the compiler doesn't eliminate this line!)
    //-----------------------------------------------------------------------------------                       
  }
		
}


