/*
TMP101 interface test for PIC18 microcontrollers
Freely distributable in this original form.
(c) 2008 Pasan Hettiarachchi
(c) Microsolutions
Any questions or comments?  admin@microsolutions.info 
*/


/* this file uses Shane Tolmie's Delay routines and Chris Twigg's I2C Routines
  for PIC microcontrollers downloaded from
  http://www.microchipc.com/

*/


#include <pic18.h>
#include "delay.h"
#include <stdio.h>
#include "serial.h"
#include "i2c.h"


__CONFIG (1,XT & OSCSDIS); //external christal oscillator
__CONFIG (2,WDTDIS);
__CONFIG (4,LVPDIS & STVRDIS);

#define TMP101ADDR 0b10010010 //Here it's assumed ADD0 is floated

unsigned char i2cBuffer[10];

void main(){

	signed int temperature;
	float Realtemp;
	
	//DS1337 adress is 0xD0
	TRISC = 0b10011000;
	init_comms();
	printf("now intialising sensor\n");
	SSPADD = 9;                         // 100 kHz I2C bus
  	SSPCON1 = 0x08;
  	SSPEN=1 ;                     		// Enable I2C bus
  	i2cBuffer[0]=0b00000001;			//adress of the configuration register

	printf("Reading Cofiguration register...\n");

	if(!GetI2C(TMP101ADDR,1,1,i2cBuffer)) printf("Device Error..\n") ;
		else printf("Config Register is %d\n",i2cBuffer[0]);
	printf("Now writing to the config register\n");
	i2cBuffer[0]=0b00000001;	//adress of the config register
	i2cBuffer[1]=0b01100000;	//data to be written to config register
								//12bit resolution, continuous conversion
	if(!SendI2C(TMP101ADDR,2,i2cBuffer)) printf("error writing to config register\n");

  	while(1){
	  	i2cBuffer[0]=0b00000000;	//adress of temperature register
	  	if (GetI2C(TMP101ADDR,1,2,i2cBuffer)){
			*(((unsigned char *)&temperature))=i2cBuffer[1];		//pointer arithmatic to access Word and bytes of a long integer
			*(((unsigned char *)&temperature)+1)=i2cBuffer[0];
			Realtemp=(((float)temperature)/256.0);
			printf("Temperature is  %0.2f\n",Realtemp);	
		  	
		}
	  	DelayS(1);
	}
	
}
